// (C)1997 Christian Janoff
// C1541.CC

#include "c1541.h"

int nbsectors_of_track(int tracknumber)
{
 int sec;

 if      (tracknumber<18) sec=21;
 else if (tracknumber<25) sec=19;
 else if (tracknumber<31) sec=18;
 else                     sec=17;

 return sec;
}

int c1541sector::get_byte(int location)
{
  return sectordata[location];
}

void c1541sector::put_byte(int location, int value)
{
 sectordata[location]=value;
}


c1541track::c1541track(int tracknumber)
{
 int sec;

 if      (tracknumber<18) sec=21;
 else if (tracknumber<25) sec=19;
 else if (tracknumber<31) sec=18;
 else                     sec=17;

 sector = new c1541sector[sec];
}

c1541track::~c1541track()
{
 delete [] sector;
}

int c1541track::get_byte(int sec, int loc)
{
 return (sector+sec)->get_byte(loc);
}

void c1541track::put_byte(int sec, int loc, int val)
{
 (sector+sec)->put_byte(loc,val);
}

int c1541disk::option_verbose      = 0;
int c1541disk::option_more_verbose = 0;
int c1541disk::option_yes          = 0;

void c1541disk::set_verbose(int val)
{
 option_verbose = val;
}

void c1541disk::set_more_verbose(int val)
{
 option_more_verbose = val;
 if (val) option_verbose = 1;
}

void c1541disk::set_yes(int val)
{
 option_yes = val;
}

c1541disk::c1541disk()
{
 //TODO!!

 int i;

 for(i=1;i<nbtracks+1;i++)
   track[i] = new c1541track(i);
}

c1541disk::~c1541disk()
{
 delete [] track;
}

int c1541disk::get_byte(int trk, int sec, int loc)
{
 return track[trk]->get_byte(sec, loc);
}

void c1541disk::put_byte(int trk, int sec, int loc, int val)
{
 track[trk]->put_byte(sec, loc, val);
}

int c1541disk::interleave_sector(int t, int s)
{
  int sec;

  const int interleave1[] = {0, 11, 1, 12, 2, 13, 3, 14, 4, 15, 5, 16, 6, 17, 7, 18, 8, 19, 9, 20, 10},
            interleave2[] = {0, 10, 1, 11, 2, 12, 3, 13, 4, 14, 5, 15, 6, 16, 7, 17, 8, 18, 9},
            interleave3[] = {0,  9, 1, 10, 2, 11, 3, 12, 4, 13, 5, 14, 6, 15, 7, 16, 8, 17},
            interleave4[] = {0,  9, 1, 10, 2, 11, 3, 12, 4, 13, 5, 14, 6, 15, 7, 16, 8};

 if      (t<18) sec = interleave1[s];
 else if (t<25) sec = interleave2[s];
 else if (t<31) sec = interleave3[s];
 else           sec = interleave4[s];

 return sec;
}
